﻿* Encoding: UTF-8.
* Encoding: .
*=============================================================================*
* TÍTULO DE LA SINTAXIS:*
* Sintaxis de preparación de la base 
* OPERACIÓN ESTADÍSTICA:*
* Recursos y Actividades de la Salud, Año 2021(RAS - 2021)*
* UNIDAD TÉCNICA RESPONSABLE:*
* Unidad de Gestión de Estadísticas Sociodemográficas en Base a Registros Administrativos*
* Dirección Estadísticas Sociodemográficas (DIES) *
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadística y Censos (INEC) *
*==============================================================================*
* Fecha última modificación: Octubre de 2025*
*==============================================================================*
* Modificado por:* 
* Equipo técnico**
* Unidad de Gestión de Estadísticas Sociodemográficas en Base a Registros Administrativos (GESRA) *
* Instituto Nacional de Estadística y Censos (INEC)*
*==============================================================================*
* Revisado por: *
* Jefe de la unidad*
* Responsable de la Unidad de Gestión de Estadísticas Sociodemográficas en Base a Registros Administrativos (GESRA) * *
* Instituto Nacional de Estadística y Censos (INEC)*
*==============================================================================*
*==============================================================================*
* Descripción:
* 1. Correr la programación en spss.
* 2. La presente sintaxis está diseñada para generar y crear las variables necesarias para la elaboración de los cuadros estadísticos de Recursos y Actividades de la Salud.
*==============================================================================*
*Sintaxis de Tabulados Recursos y Actividades de la Salud, Año 2021 (RAS - 2021)*
*==============================================================================*

string  etim_1 (a2).
VARIABLE LABELS etim_1 "Actividades de morbilidad ".
execute.
 
string  etip_2 (a2).
VARIABLE LABELS etip_2 "Actividades de prevención ".
execute.

string  tt1 (a2).
VARIABLE LABELS tt1 "Médicos especialistas y generales".
execute.
 
string  tt2 (a2).
VARIABLE LABELS tt2 "Médicos postgradistas, residentes y rurales".
execute.

string  tiempo (a2).
VARIABLE LABELS tiempo "Tiempo".
execute.

string  gye (a2).
VARIABLE LABELS gye "Generales y por especialidades".
execute.

string  esp (a2).
VARIABLE LABELS esp "Especialización".
execute.

string  auxe (a2).
VARIABLE LABELS auxe "Auxiliar de Enfermería".
execute.

string  st (a2).
VARIABLE LABELS st "Servicio Técnico".
execute.

string  psa (a2).
VARIABLE LABELS psa "Personal sanitario de apoyo".
execute.

string  ps (a2).
VARIABLE LABELS ps "Personal de servicio".
execute.

string  amf (a2).
VARIABLE LABELS amf "Ambientes físicos".
execute.

string  eqco (a2).
VARIABLE LABELS eqco "Equipos de cirugía, obstetricia y cuidados especiales".
execute.

string  ima (a2).
VARIABLE LABELS ima "Imagenología".
execute.

string  dia (a2).
VARIABLE LABELS dia "Diagnóstico".
execute.

string  eqt (a2).
VARIABLE LABELS eqt "Equipos de tratamiento".
execute.

string  lab (a2).
VARIABLE LABELS lab "Laboratorio".
execute.

string  eqs (a2).
VARIABLE LABELS eqs "Equipo de esterilización".
execute.

string  vh (a2).
VARIABLE LABELS vh "Vehículos".
execute.

string  oeq (a2).
VARIABLE LABELS oeq "Otros equipos ".
execute.

string  eqodo (a2).
VARIABLE LABELS eqodo "Equipos odontológicos ".
execute.


string  tdqui (a2).
VARIABLE LABELS tdqui "Tratamientos de diálisis, quimioterapia, radioterapia y hemodiálisis".
execute.

*ESTABLECIMIENTOS CON Y SIN INTERNACIÓN.
NUMERIC estcsi (F2.0).
if (clase >=  "01" & clase <=  "17") or (  clase =  "32") estcsi = 1.
if (clase >= "20" & clase <=  "31")  or (  clase =  "33")estcsi = 2.
VARIABLE LABELS estcsi "Tipo de Establecimiento".
EXECUTE.
VALUE LABELS estcsi 1 "Con Internación" 2 "Sin Internación".
execute.


NUMERIC sector1 (F2.0).
if (sector =  1) sector1 = 1.
if (sector =  2 or sector =3 )sector1 = 2.
VARIABLE LABELS sector1 "Sector Establecimiento".
EXECUTE.
VALUE LABELS sector1 1 "Sector Público" 2 "Sector Privado".
execute.


*************************************************************************************
*************************************************************************************
*VARIABLES PARA TABULADOS.
*************************************************************************************
*************************************************************************************

*VARIABLES DE TOTALES


alter type klcl (A1).
alter type klhs (A1).
alter type kotl(A1).
alter type kfar(A1).
alter type kbotq(A1).

NUMERIC labcl (F1.0).
if (klcl  =  "1" )  labcl = 1.
EXECUTE.
VARIABLE LABELS labcl "Laboratorio Clínico".
VALUE LABELS labcl 1 "Si".
VARIABLE LEVEL labcl (SCALE).
execute.

NUMERIC labhs (F1.0).
if (klhs  =  "1" )  labhs = 1.
EXECUTE.
VARIABLE LABELS labhs "Laboratorio Hispatológico".
VALUE LABELS labhs 1 "Si".
VARIABLE LEVEL labhs (SCALE).
execute.

NUMERIC labot (F1.0).
if (kotl  =  "1" )  labot = 1.
EXECUTE.
VARIABLE LABELS labot "Otros Laboratorios".
VALUE LABELS labot 1 "Si".
VARIABLE LEVEL labot (SCALE).
execute.


NUMERIC totlab (F1.0).
compute totlab=sum.1(labcl,labhs,labot).
VARIABLE LABELS totlab "Total Laboratorios".
VARIABLE LEVEL totlab (SCALE).
execute.


NUMERIC kfar1 (F1.0).
if (kfar  =  "1" )  kfar1 = 1.
EXECUTE.
VARIABLE LABELS kfar1 "Farmacia".
VALUE LABELS kfar1 1 "Si".
VARIABLE LEVEL kfar1 (SCALE).
execute.

NUMERIC kbotq1 (F1.0).
if (kbotq  =  "1" )  kbotq1 = 1.
EXECUTE.
VARIABLE LABELS kbotq1 "Botiquín".
VALUE LABELS kbotq1 1 "Si".
VARIABLE LEVEL kbotq1 (SCALE).
execute.


NUMERIC t (F1.0).
compute t = 1.
VARIABLE LABELS t ' '.
EXECUTE.
VALUE LABELS t 1 'Total'.



**********************************************************************************************************************************************
**********************************************************************************************************************************************
*CODIGO 
**********************************************************************************************************************************************
**********************************************************************************************************************************************
*VARIABLES CON PONDERACIÓN PARA MÉDICOS.
numeric tm8 (F10.0).
numeric tm6 (F10.0).
numeric tm4 (F10.0).
numeric tmmenos4 (F10.0).
numeric tmedicos (F10.0).
compute tm8 = k2.
compute tm6 = k3.
compute tm4 = k4.
compute tmmenos4 = k5.
compute tmedicos=k1.
VARIABLE LEVEL tm8 tm6 tm4 tmmenos4 tmedicos (SCALE).
EXECUTE.

*VARIABLES CON PONDERACIÓN PARA PSICÓLOGOS.
numeric tpsic8 (F10.0).
numeric tpsic6 (F10.0).
numeric tpsic4 (F10.0).
numeric tpsicmenos4 (F10.0).
numeric tpsic (F10.0).

compute tpsic8=sum.1(k227,k262a,k262b).
compute tpsic6=sum.1(k228,k263a,k263b).
compute tpsic4=sum.1(k229,k264a,k264b).
compute tpsicmenos4=sum.1(k230,k265a,k265b).
compute tpsic=sum.1(tpsic8,tpsic6,tpsic4,tpsicmenos4).
VARIABLE LEVEL tpsic8 tpsic6 tpsic4 tpsicmenos4(SCALE).
EXECUTE.

*VARIABLES CON PONDERACIÓN PARA ENFERMERAS.
numeric tenf8 (F10.0).
numeric tenf6 (F10.0).
numeric tenf4 (F10.0).
numeric tenfmenos4 (F10.0).
numeric tenf (F10.0).
compute tenf8=sum.1(k212,k217).
compute tenf6=sum.1(k213,k218).
compute tenf4=sum.1(k214,k219).
compute tenfmenos4=sum.1(k215,k220).
compute tenf =sum.1(tenf8,tenf6,tenf4,tenfmenos4).
VARIABLE LEVEL tenf8 tenf6 tenf4 tenfmenos4(SCALE).
EXECUTE.

*VARIABLES CON PONDERACIÓN PARA OBSTETRICES.
numeric tobst8 (F10.0).
numeric tobst6 (F10.0).
numeric tobst4 (F10.0).
numeric tobstmenos4 (F10.0).
numeric tobst (F10.0).
compute tobst8=sum.1(k202,k207).
compute tobst6=sum.1(k203,k208).
compute tobst4=sum.1(k204,k209).
compute tobstmenos4=sum.1(k205,k210).
compute tobst=sum.1(tobst8,tobst6,tobst4,tobstmenos4).

VARIABLE LEVEL tobst8 tobst6 tobst4 tobstmenos4(SCALE).
EXECUTE.

*VARIABLES CON PONDERACIÓN PARA AUXILIARES DE ENFERMERÍA.
numeric tauxenf8 (F10.0).
numeric tauxenf6 (F10.0).
numeric tauxenf4 (F10.0).
numeric tauxenfmenos4 (F10.0).
numeric tauxenf (F10.0).
compute tauxenf8=k312.
compute tauxenf6=k313.
compute tauxenf4=k314.
compute tauxenfmenos4=k315.
compute tauxenf=sum.1(tauxenf8,tauxenf6,tauxenf4,tauxenfmenos4).
VARIABLE LEVEl tauxenf8 tauxenf6 tauxenf4 tauxenfmenos4(SCALE).
EXECUTE.

*VARIABLES CON PONDERACIÓN PARA ODONTÓLOGOS.

numeric tod8 (F10.0).
numeric tod6 (F10.0).
numeric tod4 (F10.0).
numeric todmenos4 (F10.0).
numeric todont (F10.0).
compute tod8= sum.1(k995,k1000,k1005,k1010,k1015,k1020,k1025,k1030,k1035,k1055,k1060).
compute tod6= sum.1(k996,k1001,k1006,k1011,k1016,k1021,k1026,k1031,k1036,k1056,k1061).
compute tod4= sum.1(k997,k1002,k1007,k1012,k1017,k1022,k1027,k1032,k1037,k1057,k1062).
compute todmenos4= sum.1(k998,k1003,k1008,k1013,k1018,k1023,k1028,k1033,k1038,k1058,k1063).
compute todont=sum.1(tod8,tod6,tod4,todmenos4).
VARIABLE LABELS
tod8       "8 Horas diarias"
/tod6      "6 Horas diarias"
/tod4      "4 Horas diarias"
/todmenos4     "Eventual o de llamada y menos de 4 horas"
/t          "Total :"
/todont    "Total".

VARIABLE LEVEL tod8,tod6,tod4,todmenos4(SCALE).
EXECUTE.

VARIABLE LABELS tmedicos "Médicos"/
todont "Odontólogos"/
tpsic "Psicólogos"/
tenf "Enfermería"/
tobst "Obstetrices"/
tauxenf "Aux. de Enfermería".
VARIABLE LEVEL todont tpsic tenf tobst tauxenf(SCALE).

*VARIABLES DE PERSONAL MEDICO DEL ESTABLECIMIENTOS.
numeric tk1 (F10.0).
numeric tk2 (F10.0).
numeric tk3 (F10.0).
numeric tk4 (F10.0).
numeric tk5 (F10.0).
numeric tk6 (F10.0).
numeric tk7 (F10.0).
numeric tk8 (F10.0).
numeric tk9 (F10.0).
numeric tk10 (F10.0).
numeric tk11 (F10.0).
numeric tk12 (F10.0).
numeric tk13 (F10.0).
numeric tk14 (F10.0).
numeric tk15 (F10.0).
numeric tper (F10.0).
compute tk1 = sum.1(k1,-k6,-k176,-k181,-k186).
compute tk2 = k6. 
compute tk3 = k176.
compute tk4 = k181.
compute tk5 = k186.
compute tk6 = sum.1(k994,k999,k1004,k1009,k1014,k1019,k1024,k1029,k1034,k1054,k1059).
compute tk7 = sum.1(k201,k206).
compute tk8 = sum.1(k211,k216).
compute tk16 = sum.1(k226,k261a,k261b).
compute tk9 = sum.1(k221,k231,k236,k241,k246,k261c,k251,k256,k261).
compute tk10 = sum.1(k271,k276,k281,k286,k291,k296,k301,k301a,k306,k1049).
compute tk11 = sum.1(k316,k321).
compute tk12 = sum.1(k331,k336,k341,k346,k351,k1039,k1044).
compute tk13 = sum.1(k401,k406,k411,k416a,k416,k461).
compute tk14 = sum.1(k361,k366,k371,k376,k381,k386,k391,k391a,k391b,k391c,k391d,k391e,k391f,k391g).
compute tk15 = sum.1(k426,k431,k436,k441,k446,k451,k456).
compute tper = sum.1(tk1,tk2,tk3,tk4,tk5,tk6,tk7,tk8,tk9,tk10,tk11,tk12,tk13,tk14,tk15,tk16).
EXECUTE.

VARIABLE LABELS tk1  "Médicos especialistas"
/tk2 "Médicos generales"
/tk3 "Médicos postgradistas"
/tk4 "Médicos residentes"
/tk5 "Médicos rurales"
/tk6 "Odontólogos"
/tk7 "Obstetrices"
/tk8 "Enfermeras"
/tk16 "Psicólogos"
/tk9 "Otros profesionales"
/tk10  "Licenciados y/o tecnólogos"
/tk11  "Auxiliares de enfermería"
/tk12  "Auxiliares de servicio técnico"
/tk13  "Personal de apoyo sanitario"
/tk14 "Administrativo y estadística"
/tk15 "De servicio"
/tper  "Total personal".
VARIABLE LEVEL tk1 tk2 tk3 tk4 tk5 tk6 tk7 tk8 tk9 tk10 tk11 tk12 tk13 tk14 tk15 tper K6 (scale).
EXECUTE.

*PERSONAL MEDICO DEL ESTABLECIMIENTO.
numeric t8hes (F10.0).
numeric t6hes (F10.0).
numeric t4hes (F10.0).
numeric tevenes (F10.0).
numeric total1 (F10.0).
numeric t8hpos (F10.0).
numeric t6hpos (F10.0).
numeric t4hpos (F10.0).
numeric tevenpos (F10.0).
numeric total2 (F10.0).
numeric tt (F10.0).
execute.
compute t8hes = sum.1(k2,-k177,-k182,-k187).
compute t6hes = sum.1(k3,-k178,-k183,-k188).
compute t4hes = sum.1(k4,-k179,-k184,-k189).
compute tevenes = sum.1(k5,-k180,-k185,-k190).
compute total1 = sum.1(t8hes,t6hes,t4hes,tevenes).
compute t8hpos = sum.1(k177,k182,k187).
compute t6hpos = sum.1(k178,k183,k188).
compute t4hpos = sum.1(k179,k184,k189).
compute tevenpos = sum.1(k180,k185,k190).
compute total2 = sum.1(t8hpos,t6hpos,t4hpos,tevenpos).
compute tt = sum.1(total1,total2).
EXECUTE.

VARIABLE LABELS t8hes	"8 Horas diarias"
/t6hes	"6 Horas diarias"
/t4hes	"4 Horas diarias"
/tevenes	"Eventual o de llamada y menos de 4 horas "
/total1	"Total"
/t8hpos	"8 Horas diarias"
/t6hpos	"6 Horas diarias"
/t4hpos	"4 Horas diarias"
/tevenpos	"Eventual o de llamada y menos de 4 horas diarias "
/total2	"Total"
/t  "Total :"
/tt	"Total médicos".

VARIABLE LEVEL t8hes t6hes t4hes tevenes total1 t8hpos t6hpos t4hpos tevenpos total2 tt(scale).

**********************************************************************************************************************************************
**********************************************************************************************************************************************

numeric t8ho (F10.0).
numeric t6ho (F10.0).
numeric t4ho (F10.0).
numeric teveo (F10.0).
numeric totodo (F10.0).
*PERSONAL ODONTOLOGO DEL ESTABLECIMIENTO.
compute t8ho = sum.1(k995,k1000,k1005,k1010,k1015,k1020,k1025,k1030,k1035,k1055,k1060).
compute t6ho = sum.1(k996,k1001,k1006,k1011,k1016,k1021,k1026,k1031,k1036,k1056,k1061).
compute t4ho = sum.1(k997,k1002,k1007,k1012,k1017,k1022,k1027,k1032,k1037,k1057,k1062).
compute teveo = sum.1(k998,k1003,k1008,k1013,k1018,k1023,k1028,k1033,k1038,k1058,k1063).
compute totodo = sum.1(t8ho,t6ho,t4ho,teveo).
EXECUTE.

VARIABLE LABELS
t8ho       "8 Horas diarias"
/t6ho      "6 Horas diarias"
/t4ho      "4 Horas diarias"
/teveo     "Eventual o de llamada y menos de 4 horas"
/t          "Total:"
/totodo    "Total".

VARIABLE LEVEL t8ho t6ho t4ho teveo totodo (scale).
*VARIABLES DE OTROS PROFESIONALES DE LA SALUD.
numeric t8hp (F10.0).
numeric t6hp (F10.0).
numeric t4hp (F10.0).
numeric tevep (F10.0).
numeric totop (F10.0).

compute t8hp = sum.1(k202,k207,k212,k217,k222,k227,k262a,k262b,k232,k237,k242,k247,k262c,k252,k257,k262).
compute t6hp = sum.1(k203,k208,k213,k218,k223,k228,k263a,k263b,k233,k238,k243,k248,k263c,k253,k258,k263).
compute t4hp = sum.1(k204,k209,k214,k219,k224,k229,k264a,k264b,k234,k239,k244,k249,k264c,k254,k259,k264).
compute tevep =sum.1(k205,k210,k215,k220,k225,k230,k265a,k265b,k235,k240,k245,k250,k265c,k255,k260,k265).
compute totop = sum.1(t8hp,t6hp,t4hp,tevep).
EXECUTE.
VARIABLE LABELS
t8hp       "8 Horas diarias"
/t6hp      "6 Horas diarias"
/t4hp      "4 Horas diarias"
/tevep     "Eventual o de llamada y menos de 4 horas "
/totop    "Total".

VARIABLE LEVEL t8hp t6hp t4hp tevep totop(SCALE).

*VARIABLES PARA MEDICOS ESPECIALISTAS .
numeric tk156 (F10.0).
compute tk156 = sum.1(k156,k161,k166).
VARIABLE LABELS tk156 'Laboratorio 2/'.
EXECUTE.
numeric tmed (F10.0).
compute tmed = sum.1(k6,k11,k16,k16a,k16b,k16c,k16d,k16e,k16f,k191d,k41,k21,k26,k31,k36,k46,k51,k56,k61,k66,k71,k76,k81,
k86,k91,k96,k101,k106,k111,k116,k121,k126,k131,k136,k141,k146,k151,tk156,k171,k191,
k191a,k191b,k191c,k191e,k191f,k191g,k191h,k191i,k191j,k191k,k191l,k191m,k191n,k191o,k191p,k191q,k191r,k191s,k191t,k191u,
k191w,k191x,k191y,k191z,k191aa,k191cc,k191dd,k191ee).
VARIABLE LABELS tmed 'Total médicos'.
VARIABLE LEVEL tmed k6 k11 k16 k16a k16b k16c k16d k16e k16f k191d k41 k21 k26 k31 k36 k46 k51 k56 k61 k66 k71 k76,k81 
k86 k91 k96 k101 k106 k111 k116 k121 k126 k131 k136 k141 k146 k151 tk156 k171 k191 k191a k191b k191c k191e k191f k191g k191h k191i k191j k191k k191l k191m k191n k191o k191p k191q k191r k191s k191t k191u 
k191w k191x k191y k191z k191aa k191cc k191dd k191ee(SCALE).
EXECUTE.

VARIABLE LABELS k6 'Generales'.
VARIABLE LABELS k11 'Cirujanos Generales'.
VARIABLE LABELS k16 'Cirujanos Plásticos y Reconstructores'.
VARIABLE LABELS k16a 'Cirujanos Cardiacos'.
VARIABLE LABELS k16b 'Cirujanos Cardiatorácicos'.
VARIABLE LABELS k16c 'Cirujanos Cardiovasculares'.
VARIABLE LABELS k16d 'Cirujanos de cabeza y cuello'.
VARIABLE LABELS k16e 'Cirujanos Pediátricos'.
VARIABLE LABELS k16f 'Cirujanos Torácicos'.
VARIABLE LABELS k191d 'Cirugía Vasculares y Endovasculares'.
VARIABLE LABELS k41 'Ortopédicos y Traumatólogos'.
VARIABLE LABELS k21 'Medicina Interna (Internistas)'.
VARIABLE LABELS k26 'Anestesiólogos'.
VARIABLE LABELS k31 'Cardiólogos'.
VARIABLE LABELS k36 'Neurólogos'.
VARIABLE LABELS k46 'Psiquiatras'.
VARIABLE LABELS k51 'Oftalmólogos'.
VARIABLE LABELS k56 'Otorrinolaringólogos'.
VARIABLE LABELS k61 'Hematólogos'.
VARIABLE LABELS k66 'Intensivistas'.
VARIABLE LABELS k71 'Nefrólogos'.
VARIABLE LABELS k76 'Neumólogos'.
VARIABLE LABELS k81 'Gastroenterólogos'.
VARIABLE LABELS k86 'Geriátras y Gerontólogos'.
VARIABLE LABELS k91 'Oncólogos'.
VARIABLE LABELS k96 'Urólogos'.
VARIABLE LABELS k101 'Dermatólogos'.
VARIABLE LABELS k106 'Infectólogos'.
VARIABLE LABELS k111 'Endocrinólogos'.
VARIABLE LABELS k116 'Alergólogos'.
VARIABLE LABELS k121 'Diabetólogos'.
VARIABLE LABELS k126 'Pediatras'.
VARIABLE LABELS k131 'Neonatólogos'.
VARIABLE LABELS k136 'Ginecólogos/Obstetras'.
VARIABLE LABELS k141 'De Salud Pública (Salubristas)'.
VARIABLE LABELS k146 'Epidemiólogos'.
VARIABLE LABELS k151 'De Salud Familiar y Comunitaria'.
VARIABLE LABELS k156 'Patólogo Clínico'.
VARIABLE LABELS k161 'Anatomo Patólogo'.
VARIABLE LABELS k166 'Citólogo'.
VARIABLE LABELS k171 'Radiólogo'.
VARIABLE LABELS k176 'Medicos Postgradistas'.
VARIABLE LABELS k181 'Médicos Residentes'.
VARIABLE LABELS k186 'Médicos Rurales'.
VARIABLE LABELS k191a 'Nutriólogos'.
VARIABLE LABELS k191b 'Reumatólogo'.
VARIABLE LABELS k191c 'Cardiotorácico'.
VARIABLE LABELS k191e 'Neurocirujanos'.
VARIABLE LABELS k191f 'Fisiatras'.
VARIABLE LABELS k191g 'Médicos Acupunturistas'.
VARIABLE LABELS k191h 'Especialistas en Atención Primaria en Salud'.
VARIABLE LABELS k191i 'Audiólogos / Foniatras'.
VARIABLE LABELS k191j 'Biólogos Moleculares'.
VARIABLE LABELS k191k 'Genetistas Clínicos'.
VARIABLE LABELS k191l 'Genetistas Médicos'.
VARIABLE LABELS k191m 'Homeópatas'.
VARIABLE LABELS k191n 'Imagenólogos'.
VARIABLE LABELS k191o 'Inmunólogos'.
VARIABLE LABELS k191p 'Médicos Aeroespaciales'.
VARIABLE LABELS k191q 'Médicos Críticos'.
VARIABLE LABELS k191r 'Médicos de Emergencia'.
VARIABLE LABELS k191s 'Médicos del Deporte'.
VARIABLE LABELS k191t 'Médicos Ocupacional'.
VARIABLE LABELS k191u 'Médicos Nucleares'.
VARIABLE LABELS k191w 'Neurofisiólogo Clínico'.
VARIABLE LABELS k191x 'Neuropsicólogos'.
VARIABLE LABELS k191y 'Parasitólogos'.
VARIABLE LABELS k191z 'Proctólogos'.
VARIABLE LABELS k191aa 'Psiquiatras Infantiles'.
VARIABLE LABELS k191cc 'Subespecialistas'.
VARIABLE LABELS k191dd 'Terapistas Neural'.
VARIABLE LABELS k191ee 'Especialista en Ultrasonido'.
VARIABLE LABELS k191 'Otros'.
EXECUTE.

*VARIABLES DE ESPECICALISTAS ODONTOLOGOS.

numeric teod (F10.0).
compute teod = sum.1(k994,k999,k1004,k1009,k1014,k1019,k1024,k1029,k1034,k1054,k1059).
VARIABLE LEVEL teod(SCALE).
VARIABLE LABELS teod 'Total Especialistas Odontólogos'.
EXECUTE.

VARIABLE LABELS k994 "Odontólogos generales".
VARIABLE LABELS k999 "Odontólogos rurales".
VARIABLE LABELS k1004 "Cirujanos maxilofaciales".
VARIABLE LABELS k1009 "Implantólogos".
VARIABLE LABELS k1014 "Odontopediátras".
VARIABLE LABELS k1019 "Endodoncistas".
VARIABLE LABELS k1024 "Periodoncistas".
VARIABLE LABELS k1029 "Ortodoncistas".
VARIABLE LABELS k1034 "Rehabilitadores orales".
VARIABLE LABELS k1054 "Exodoncistas".
VARIABLE LABELS k1059 "Otros".

VARIABLE LEVEL k994 k999 k1004 k1009 k1014 k1019 k1024 k1029 k1034 k1054 k1059(SCALE).

*VARIABLES PARA OTROS PROFESIONALES DE LA SALUD.
numeric op2 (F10.0).
numeric op3 (F10.0).
numeric op4 (F10.0).
numeric op5 (F10.0).
numeric op6 (F10.0).
numeric op8 (F10.0).
numeric op1 (F10.0).
numeric op11 (F10.0).
numeric op7 (F10.0).
numeric op9 (F10.0).
numeric op10 (F10.0).
numeric tops (F10.0).

compute op2 = sum.1(k201,k206).
compute op3 = sum.1(k211,k216).
compute op4 = sum.1(k221).
compute op5 = sum.1(k226,k261a,k262a).
compute op6 = sum.1(k231).
compute op8 = sum.1(k236).
compute op1 = sum.1(k241,k246).
compute op11 = sum.1(k261c).
compute op7 = sum.1(k251).
compute op9 = sum.1(k256).
compute op10 = sum.1(k261).
compute tops = sum.1(op1,op2,op3,op4,op5,op6,op7,op8,op9,op10,op11).
EXECUTE.

VARIABLE LEVEL op1 op2 op3 op4 op5 op6 op7 op8 op9 op10 op11 tops (scale).

VARIABLE LABELS op2 "Obstetrices".
VARIABLE LABELS op3 "Enfermeras".
VARIABLE LABELS op4 "Nutricionistas".
VARIABLE LABELS op5 "Psicólogos y Psicorehabilitador".
VARIABLE LABELS op6 "Educadores para la salud".
VARIABLE LABELS op8 "Ingenieros sanitarios".
VARIABLE LABELS op1 "Bioquímicos y químicos farmacéuticos".
VARIABLE LABELS op11 "Microbiólogos".
VARIABLE LABELS op7 "Trabajadoras sociales".
VARIABLE LABELS op9 "Ingenieros ambientales".
VARIABLE LABELS op10 "Otros profesionales".
VARIABLE LABELS tops 'Total profesional'.

*VARIABLES PARA LICENCIADOS/TECNOLOGOS.
numeric tlict (F10.0).
compute tlict=sum.1(k271,k276,k281,k286,k291,k296,k301,k301a,k1049,k306).
VARIABLE LEVEL tlict (scale).
VARIABLE LEVEL k271 k276 k281 k286 k291 k296 k301 k301a k1049 k306(SCALE).
EXECUTE.

VARIABLE LABELS k271 "En fisioterapia".
VARIABLE LABELS k276 "En anestesiología".
VARIABLE LABELS k281 "En laboratorio clínico".
VARIABLE LABELS k286 "En hispatología".
VARIABLE LABELS k291 "En radiología".
VARIABLE LABELS k296 "En saneamiento ambiental".
VARIABLE LABELS k301 "En alimentos".
VARIABLE LABELS k301a "Paramédicos".
VARIABLE LABELS k1049 "Mecánico dental".
VARIABLE LABELS k306 "Otros".
VARIABLE LABELS tlict 'Total'.

*VARIABLES PARA PERSONAL ADMINISTRATIVOS Y PROMOTORES.
numeric taenfer (F10.0).
numeric tst (F10.0).
numeric tpsa (F10.0).
numeric ttotal (F10.0).

compute taenfer = sum.1(k316,k321).
compute tst = sum.1(k341,k346,k336,k331,k1044,k1039,k351).
compute tpsa = sum.1(k401,k406,k411,k416,k416a).
compute ttotal = sum.1(taenfer,tst,tpsa,k461).
EXECUTE.

VARIABLE LABELS taenfer 'Total aux. enfermeria'.
VARIABLE LABELS k316 'Con certificado'.
VARIABLE LABELS k321 'Sin certificado'.
VARIABLE LABELS tst 'Total otros auxiliares'.
VARIABLE LABELS tpsa 'Total pers. sanitario de apoyo'.
VARIABLE LABELS k341 'De Farmacia'.
VARIABLE LABELS k346 'De Laboratorio'.
VARIABLE LABELS k336 'De Radiología'.
VARIABLE LABELS k331 'De Fisioterapia'.
VARIABLE LABELS k1044 'Auxiliares de odontología'.
VARIABLE LABELS k1039 'Asistentes dentales'.
VARIABLE LABELS k351 'Otros auxiliares 1/'.
VARIABLE LABELS k396 'Total personal sanitario de apoyo'.
VARIABLE LABELS k401 'Inspectores sanitarios'.
VARIABLE LABELS k406 'Empleados sanitarios'.
VARIABLE LABELS k411 'Tecnólogo de atención primaria de salud (TAPS)'.
VARIABLE LABELS k416 'Otros'.
VARIABLE LABELS k416a 'Saneamiento Ambiental'.
VARIABLE LABELS k461 'Promotores de salud en la comunidad'.
VARIABLE LABELS ttotal 'Total personal'.

VARIABLE LEVEL taenfer k316 k321 tst k341 k346 k336 k331 k1044 k1039 k351 k396 k401 k406 k411 k416 k416a k461 tpsa tst ttotal(SCALE).

*VARIABLES PARA PERSONAL DE ESTADISTICA Y ADMINISTRATIVO.
numeric tadm (F10.0).
numeric tpserv (F10.0).
numeric ttpesad (F10.0).

compute tadm=sum.1(k361,k366,k376,k381,k386,k391,k391a,k391b,k391c,k391d,k391e,k391f,k391g).
compute tpserv=sum.1(k426,k431,k436,k441,k446,k451,k456).
compute ttpesad=sum.1(k371,tadm,tpserv).
VARIABLE LABELS tadm 'Total Personal Administrativo'.
VARIABLE LABELS tpserv 'Total Personal de Servicio'.
VARIABLE LABELS ttpesad 'Total Personal'.
VARIABLE LEVEL tadm tpserv ttpesad(SCALE).
EXECUTE.

VARIABLE LABELS k361 'Directivos y/o Gerentes y/o Administradores'.
VARIABLE LABELS k366 'De Talento humano'.
VARIABLE LABELS k371 'De Estadística y Admisión'.
VARIABLE LABELS k376 'De Recursos Financieros'.
VARIABLE LABELS k381 'De Secretaría- Recepcionistas'.
VARIABLE LABELS k386 'De Servicios Institucionales: (Bodegueros, guardalmacén, etc)'.
VARIABLE LABELS k391a 'De Calidad'.
VARIABLE LABELS k391b 'De Comunicación Social'.
VARIABLE LABELS k391c 'De Planificación'.
VARIABLE LABELS k391d 'De Jurídico'.
VARIABLE LABELS k391e 'De Informáticos'.
VARIABLE LABELS k391f 'De Atención al Usuario'.
VARIABLE LABELS k391g 'EDe Riesgos'.
VARIABLE LABELS k391 'Otros'.
VARIABLE LABELS k426 'Alimentación y dietética'.
VARIABLE LABELS k431 'Lavandería, ropería y costura'.
VARIABLE LABELS k436 'Limpieza'.
VARIABLE LABELS k441 'Conserjes, choferes y guardianes'.
VARIABLE LABELS k446 'Mantenimiento'.
VARIABLE LABELS k451 'Camilleros'.
VARIABLE LABELS k456 'Otros'.

VARIABLE LEVEL k371 k361 k366 k376 k381 k386 k391 k426 k431 k436 k441 k446 k451 k456(SCALE).

*VARIABLES PARA AMBIENTES FÍSICOS.
numeric tamfis (F10.0).
compute tamfis=sum.1(k1398,k1399,k1400,k1401).

VARIABLE LABELS tamfis 'Cunas, termocunas y/o incubadoras'.

EXECUTE.

VARIABLE LABELS k1379 'Salas de Operaciones (Quirófanos generales y de emergencia)'.
VARIABLE LABELS k1380 'Salas de cuidados intensivos'.
VARIABLE LABELS k1381 'Salas de cuidados intermedios'.
VARIABLE LABELS k1382 'Salas de parto'.
*VARIABLE LABELS k1382a 'Habitaciones simples'.
*VARIABLE LABELS k1382b 'Habitaciones dobles y más'.
VARIABLE LABELS k1383 'Total Ambientes'.
VARIABLE LABELS k1384 'Mesas de operaciones'.
VARIABLE LABELS k1385 'Equipos de anestesia'.
VARIABLE LABELS k1386 'Monitores'.
VARIABLE LABELS k1387 'Electrobisturí'.
VARIABLE LABELS k1388 'Electrocauterio'.
VARIABLE LABELS k1389 'Lámpara cielítica'.
VARIABLE LABELS k1390 'Coche de paro'.
VARIABLE LABELS k1391 'Coche de cardio-reanimación'.
VARIABLE LABELS k1392 'Equipo de fibrilación'.
VARIABLE LABELS k1393 'Torre de laparoscopía'.
VARIABLE LABELS k1394 'Equipo de láser'.
VARIABLE LABELS k1395 'Respirador'.
VARIABLE LABELS k1396 'Succionador'.
VARIABLE LABELS k1397 'Mesas ginecológicas'.
VARIABLE LABELS tamfis 'Cunas, termocunas y/o incubadoras'.
VARIABLE LABELS k1402 'Otros 2/'.
VARIABLE LABELS k1403 'Total Equipos'.

VARIABLE LEVEL k1379 k1380 k1381 k1382 k1383 k1384 k1385 k1386 k1387 k1388 k1389 k1390 k1391 k1392 k1393 k1394 
k1395 k1396 k1397 tamfis k1402 k1403(SCALE).
*VARIABLES PARA IMAGENOLOGIA.

VARIABLE LEVEL k1200 k1201 k1201aa k1202 k1203 k1273 k1204 k1205 k1206 k1206b k1207 k1208 (SCALE).

VARIABLE LABELS k1200 'Rayos X (Fijo)'.
VARIABLE LABELS k1201 'Rayos X (Portátil)'.
VARIABLE LABELS k1201aa 'Arco en C (Fijo o Portátil)'.
VARIABLE LABELS k1202 'Tomógrafos'.
VARIABLE LABELS k1203 'Ecógrafos (convencional o portátil)'.
VARIABLE LABELS k1273 'Ecógrafo dopper color'.
VARIABLE LABELS k1204 'Fluoroscopios'.
VARIABLE LABELS k1205 'Mamógrafos'.
VARIABLE LABELS k1206 'Resonancia Magnética'.
VARIABLE LABELS k1206b 'Desintómetro'.
VARIABLE LABELS k1207 'Otros'.
VARIABLE LABELS k1208 'Equipos de Imagenología'.


VARIABLE LABELS k1265 'Electroencefalógrafo'.
VARIABLE LABELS k1266 'Electrocardiógrafo'.
VARIABLE LABELS k1267 'Ecocardiógrafo'.
VARIABLE LABELS k1268 'Angiógrafo'.
VARIABLE LABELS k1269 'Espirómetro'.
VARIABLE LABELS k1270 'Ergonómetro'.
VARIABLE LABELS k1271 'Endoscopio'.
VARIABLE LABELS k1272 'Colonoscopio'.
VARIABLE LABELS k1274 'Audiómetro'.
VARIABLE LABELS k1275 'Electromiógrafo'.
VARIABLE LABELS k1276 'Gammacámara'.
VARIABLE LABELS k1277 'Otros'.
VARIABLE LABELS k1278 'Equipos de Diagnóstico'.


VARIABLE LABELS k1343 'Fisioterapia'.
VARIABLE LABELS k1344 'Electroshock'.
VARIABLE LABELS k1344c 'Equipo para Electroterapia'.
VARIABLE LABELS k1345 'Equipo de diálisis'.
VARIABLE LABELS k1346 'Litotritor'.
VARIABLE LABELS k1346d 'Equipo para Quimioterapia'.
VARIABLE LABELS k1347 'Equipo de Tratamiento'.


VARIABLE LEVEL k1265 k1266 k1267 k1268 k1269 k1270 k1271 k1272 k1274 k1275 k1276 k1277 k1278 k1343 k1344 k1344c k1345 k1346 k1346d k1347 (SCALE).
*VARIBLES DE FARMACIA, LABORATORIO Y OTROS.

*if(kfar>0) kfar=1.
*f(kbotq>0) kbotq=1.

*if(kbcosan>0) kbcosan=1.
*if(kbcolec>0) kbcolec=1.
*if(klcl>0) klcl=1.
*if(klhs>0) klhs=1.
*if(kotl>0) kotl=1.

*EXECUTE.

VARIABLE LABELS kfar "Farmacia".
VARIABLE LABELS kbotq "Botiquín".
VARIABLE LABELS klcl "Laboratorio Clínico".
VARIABLE LABELS klhs "Laboratorio Hispatológico".
VARIABLE LABELS kotl "Otros".
VARIABLE LABELS k1404 'Esterilizador en seco'.
VARIABLE LABELS k1405 'Auto claves'.
VARIABLE LABELS k1406 'Otros'.

VARIABLE LABELS k1408 'Ambulancias'.
VARIABLE LABELS k1409 'Vehículos de transporte'.
VARIABLE LABELS k1410 'Otros'.
VARIABLE LABELS k1410d 'Camas de recuperación'.
VARIABLE LABELS k1410e 'Camas de emergencia'.
VARIABLE LABELS k1410f 'Sillones (Quimioterapias, diálisis y otros)'.
VARIABLE LABELS k1410g 'Camillas'.
VARIABLE LABELS k1410h 'Sillas para nebulizaciones'.
VARIABLE LABELS k1410i 'Balanzas de recien nacidos'.
VARIABLE LABELS k1410j 'Balanzas de pedestal'.
VARIABLE LABELS k1410k 'Tensiometros de pedestal'.
VARIABLE LABELS k1410l 'Tensiometros de pared'.
VARIABLE LABELS k1410m 'Fonendoscopio'.
VARIABLE LABELS k1410n 'Refrigeradoras (uso de medicamento)'.
VARIABLE LABELS k1410o 'Vaporizador'.
VARIABLE LABELS k1410p 'Tensiometro digital'.
VARIABLE LABELS k1410q 'Shailon'.
VARIABLE LABELS k1411 'Total Otros Equipos del Estableciemiento'.
EXECUTE.

VARIABLE LEVEL kfar kbotq klcl klhs kotl k1404 k1405 k1406 k1408 k1409 k1410 k1410d k1410e k1410f k1410g k1410h k1410i k1410j
k1410k k1410l k1410m k1410n k1410o k1410p k1410q k1411(SCALE).
EXECUTE.

*VARIBLES DE EQUIPOS ODONTOLOGICOS.
numeric tequod (F10.0).
compute tequod=sum.1(k978,k979,k980,k981,k982,k983,k984,k985,k986,k987,k988,k989,k990,k991,k992,k992a,k992b,k992c,k992d).
VARIABLE LABELS tequod 'Total Equipos Odontológicos'.
EXECUTE.

VARIABLE LABELS k978 'Computador completo pc/computador portátil '.
VARIABLE LABELS k979 'Equipo odontológico'.
VARIABLE LABELS k980 'Compresor de odontología'.
VARIABLE LABELS k981 'Esterilizador y/o autoclave'.
VARIABLE LABELS k982 'Ultrasonido (cavitrón)'.
VARIABLE LABELS k983 'Taburete giratorio dental'.
VARIABLE LABELS k984 'Equipo instrumental para operatoria dental'.
VARIABLE LABELS k985 'Negatoscopio'.
VARIABLE LABELS k986 'Equipo instrumental de cirugía dental'.
VARIABLE LABELS k987 'Equipo instrumental de diagnóstico dental'.
VARIABLE LABELS k988 'Equipo instrumental de profilaxís dental'.
VARIABLE LABELS k989 'Set de desechos'.
VARIABLE LABELS k990 'Fregadero mas escurridor'.
VARIABLE LABELS k991 'Equipo de RX de odontología'.
VARIABLE LABELS k992 'Otros'.
VARIABLE LABELS k992a 'Micromotor'.
VARIABLE LABELS k992b 'Turbina'.
VARIABLE LABELS k992c 'Lampara halógena'.
VARIABLE LABELS k992d 'Sillón dental'.

VARIABLE LEVEL k978,k979,k980,k981,k982,k983,k984,k985,k986,k987,k988,k989,k990,k991,k992,k992a,k992b,k992c,k992d tequod(SCALE).

*CONSULTAS DE MORBILIDAD, PREVENCION Y ESTOMATOLOGIA PRIMARIAS Y SUBSECUENTES.
numeric mprim (F10.0).
numeric msubs (F10.0).
numeric tcmps (F10.0).
numeric pprim (F10.0).
numeric psubs (F10.0).
numeric tcpps (F10.0).
numeric tcest (F10.0).
numeric emer (F10.0).
numeric tmpest (F10.0).
compute mprim= sum.1(k509,k510,k511,k552,k553).
compute msubs= sum.1(k513,k514,k515,k555,k556).
compute tcmps = sum.1(mprim,msubs).
compute pprim = sum.1(k722,k723,k724).
compute psubs= sum.1(k890,k891,k892).
compute tcpps = sum.1(pprim,psubs).
compute tcest = sum.1(k1105,k1106,k1107).
compute emer =  sum.1(k975,k976).
compute tmpest = sum.1(tcmps,tcpps,tcest).
EXECUTE.
VARIABLE LEVEL mprim,msubs,tcmps,pprim,psubs,tcpps,tcest,emer,tmpest,k1106,k1107(SCALE).

numeric morb (F1.0).
numeric preve (F1.0).
numeric esto (F1.0).
numeric temerg (F1.0).
if(tcmps>0) morb=1.
if(tcpps >0) preve=1.
if(tcest  >0) esto=1.
if(emer  >0) temerg=1.
EXECUTE.

VARIABLE LABELS mprim 'Primarias consultas de morbilidad'.
VARIABLE LABELS pprim 'Primarias consultas de prevención'.
VARIABLE LABELS k1106 'Primarias consultas de estomatología'.
VARIABLE LABELS msubs 'Subsecuentes consultas de morbilidad'.
VARIABLE LABELS psubs 'Subsecuentes consultas de prevención'.
VARIABLE LABELS k1107 'Subsecuentes consultas de estomatología'.
VARIABLE LABELS tcmps 'Total consultas de morbilidad'.
VARIABLE LABELS tcpps 'Total consultas de prevención'.
VARIABLE LABELS tcest 'Total consultas de estomatología'.
VARIABLE LABELS emer 'Total de Emergencia'.
VARIABLE LABELS k1105 'Morbilidad consultas de estomatología'.
VARIABLE LABELS morb 'Morbilidad'.
VARIABLE LABELS preve "Prevención".
VARIABLE LABELS esto 'Estomatología'.
VARIABLE LABELS tmpest 'Total'.

VARIABLE LABELS k974 'Número de Urgencias'.
VARIABLE LABELS k975 'Número de Atenciones (urgencias)'.
VARIABLE LABELS k976 'Número de Ingresos /emergencias'.
VARIABLE LABELS k977c 'Número de Intervenciones Quirúrgicas en el servicio de hospitalización'.
execute.

*VARIABLE LABELS k977a 'Núm. de Intervenciones Quirúrgicas derivadas dentro del mismo establecimiento'.
*VARIABLE LABELS k977b 'Núm. de Intervenciones Quirúrgicas derivada aa otro establecieminto para cirugía'.
VARIABLE LABELS temerg 'Emergencia'.

VALUE LABELS morb 1'Morbilidad' /preve 1'Prevención' /esto 1'Estomatología' /temerg 1'Emergencia'.
VARIABLE LEVEL k976(SCALE).
*VARIABLES DE CONSULTAS DE MORBILIDAD, PREVENCIÓN Y ESTOMATOLOGIA DE ESTABLECIMIENTOS POR GRUPOS DE EDAD.
numeric e1 (F10.0).
numeric e2 (F10.0).
numeric e3 (F10.0).
numeric e4 (F10.0).
numeric e5 (F10.0).
numeric e6 (F10.0).
numeric e7 (F10.0).
numeric e8 (F10.0).
numeric e9 (F10.0).
numeric e10 (F10.0).
numeric e11 (F10.0).
numeric emerg (F10.0).
numeric ingres (F10.0).
numeric intern (F10.0).
numeric tconed (F10.0).
numeric tcona (F10.0).

compute e1 = sum.1(k466,k517).
compute e2 = sum.1(k468,k469,k519,k520).
compute e3 = sum.1(k471,k472,k522,k523).
compute e4 = sum.1(k474,k475,k525,k526).
compute e5 = sum.1(k477,k478,k479,k528,k529).
compute e6 = sum.1(k481,k482,k483,k531,k532).
compute e7 = sum.1(k485,k486,k487,k534,k535).
compute e8 = sum.1(k489,k490,k491,k537,k538).
compute e9 = sum.1(k493,k494,k495,k540,k541).
compute e10 = sum.1(k497,k498,k499,k543,k544).
compute e11 = sum.1(k501,k502,k503,k546,k547).
compute emerg = k975.
compute ingres = k976.
compute tconed  = sum.1(e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11).
compute tcona  = sum.1(e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,emerg).

EXECUTE.

numeric gedad (F1.0).
if tcona>0 gedad=1.
EXECUTE.

VARIABLE LABELS tcona "Total consultas 1/"
/e1 "Menos de 1 mes"
/e2 "1 - 11 meses"
/e3 "1 - 4 años"
/e4 "5 - 9 años"
/e5 "10 - 14 años"
/e6 "15 - 19 años"
/e7 "20 - 35 años"
/e8 "36 - 49 años"
/e9 "50 - 64 años"
/e10 "65 y más años"
/e11 "Edad no especificada"
/emerg "Emergencia (número de atenciones)"
/ingres "Emergencia (número de ingresos)"
/intern  "Emergencia (número de intervenciones quirúrgicas)"
/t  "Total"
/tconed "Subtotal Consultas"
/gedad "Consultas de morbilidad (primeras y subsecuentes) por grupos de edad".

VALUE LABELS gedad 1'Consultas de morbilidad (primeras y subsecuentes) por grupos de edad'.
VARIABLE LEVEL e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,emerg,ingres,intern,tconed,tcona,gedad(SCALE).

*VARIABLES DE CONSULTAS DE MORBILIDAD POR MEDICO, OBSTETRIZ, PSICOLOGO.
numeric tcmm (F10.0).
numeric tcmos (F10.0).
numeric tcmpsi (F10.0).
numeric tcmae (F10.0).
numeric ttcmem (F10.0).
numeric totalmb (F10.0).


compute tcmm =  sum.1(k505,k549).
compute tcmos = k506.
compute tcmpsi = sum.1(k507,k550).
compute tcmae = sum.1(k508,k551).
compute ttcmem= sum.1(tcmm).
compute totalmb= sum.1(ttcmem,tcmos,tcmpsi).
VARIABLE LABELS tcmm 'Médicos' 
/tcmos 'Obstetriz' /tcmpsi 'Psicólogos' 
/tcmae ' Actividades de Enfermería' /ttcmem 'Total Consultas Médico' /totalmb 'Total Consultas'.
EXECUTE.
VARIABLE LEVEL tcmm tcmos tcmpsi tcmae ttcmem totalmb(SCALE).
*VARIABLES DE CONSULTAS PRIMARIAS DE PREVENCION, PLANIFICACION FAMILIAR.
numeric tprv1 (F10.0).
numeric tprv2 (F10.0).
numeric tprv3 (F10.0).
numeric tn (F10.0).
numeric tprv4 (F10.0).
numeric tprv5 (F10.0).
numeric ta (F10.0).
numeric tprv6 (F10.0).
numeric tprv7 (F10.0).
numeric tprv8 (F10.0).
numeric tprv9 (F10.0).
numeric tad (F10.0).
numeric tprv10 (F10.0).
numeric tprv11 (F10.0).
numeric tm (F10.0).
numeric tprv12 (F10.0).
numeric tprv13 (F10.0).
numeric tm1 (F10.0).
numeric tprv14 (F10.0).
numeric tprv32 (F10.0).
numeric tprv33 (F10.0).
numeric tprv34 (F10.0).
numeric tprv16 (F10.0).
numeric tprv17 (F10.0).
numeric tprv18 (F10.0).
numeric tprv19 (F10.0).
numeric tprv20 (F10.0).
numeric tprv35 (F10.0).
numeric tprv36 (F10.0).
numeric tprv37 (F10.0).
numeric tprv38 (F10.0).
numeric tedad (F10.0).
numeric ttiro (F10.0).
numeric ttotr (F10.0).

compute tedad = sum.1(k684a,k685a,k686a,k700a,k702a). 
compute ttiro = sum.1(k825a,k834a).
compute ttotr = sum.1(k825b,k834b,k834c).
compute tprv1 = k650.
compute tprv2 = sum.1(k652,k653).
compute tprv3 = sum.1(k655,k656).
compute tn = sum.1(tprv1,tprv2,tprv3).
compute tprv4 = sum.1(k658,k659,k660,k666,k667).
compute tprv5 = sum.1(k662,k663,k664,k669,k670).
compute ta = sum.1(tprv4,tprv5).
compute tprv6 = sum.1(k672,k673,k674,k688,k690).
compute tprv7 = sum.1(k676,k677,k678,k692,k694).
compute tprv8 = sum.1(k680,k681,k682,k696,k698).
compute tprv9 = sum.1(k684,k685,k686,k700,k702).
compute tad = sum.1(tprv6,tprv7,tprv8,tprv9).
compute tprv10 = sum.1(k704,k705).
compute tprv11 = sum.1(k710,k711).
compute tm = sum.1(tprv10,tprv11).
compute tprv12 = sum.1(k713,k714).
compute tprv13 = sum.1(k719,k720).
compute tm1 = sum.1(tprv12,tprv13).
compute tprv14 = sum.1(k726,k727,k728,k728aa,k768,k769,k770,k770aa).
compute tprv32 = sum.1(k729a,k730a,k731a,k731aa,k732a,k733a,k734a,k734aa,k771a,k772a,k773a,k773aa,k774a,k775a,k776a,k776aa).
compute tprv33 = sum.1(k729b,k730b,k731b,k731bb,k732b,k733b,k734b,k734bb,k771b,k772b,k773b,k773bb,k774b,k775b,k776b,k776bb).
compute tprv34 = sum.1(k729c,k730c,k731c,k731cc,k732c,k733c,k734c,k734cc,k771c,k772c,k773c,k773cc,k774c,k775c,k776c,k776cc).
compute tprv16 = sum.1(k735,k736,k737,k737aa,k738,k739,k740,k740aa,k777,k778,k779,k779aa,k780,k781,k782,k782aa).
compute tprv17 = sum.1(k741,k742,k743,k743aa,k744,k745,k746,k746aa,k783,k784,k785,k785aa,k786,k787,k788,k788aa).
compute tprv18 = sum.1(k747,k748,k749,k749aa,k789,k790,k791,k791aa).
compute tprv19 = sum.1(k751,k752,k752aa).
compute tprv20 = sum.1(k754,k755,k755aa,k796,k797,k797aa).
compute tprv35 = sum.1(k756a,k757a,k758a,k758aa,k798a,k799a,k800a,k800aa).
compute tprv36 = sum.1(k756b,k757b,k758b,k758bb,k798b,k799b,k800b,k800bb).
compute tprv37 = sum.1(k756,k757,k758,k758aaa,k759,k760,k761,k761aa,k798,k799,k800,k800aaa,k801,k802,k803,k803aa).
compute tprv38 = sum.1(k762,k763,k764,k764aa,k765,k766,k767,k767aa,k804,k805,k806,k806aa,k807,k808,k809,k809aa).

EXECUTE.
numeric tpf (F10.0).
numeric tprv23 (F10.0).
numeric tprv24 (F10.0).
numeric tprv25 (F10.0).
numeric tprv26 (F10.0).
numeric tprv27 (F10.0).
numeric tprv28 (F10.0).
numeric tprv29 (F10.0).
numeric tprv30 (F10.0).
numeric tcan (F10.0).
numeric tprv31 (F10.0).
numeric tpc (F10.0).
numeric tcer (F10.0).
numeric tpartom(f10.0).
numeric tpartoh(f10.0).
numeric totalpar1(f10.0).
numeric totalpar2(f10.0).

compute tpf = sum.1(tprv14,tprv32,tprv33,tprv34,tprv16,tprv17,tprv18,tprv19,tprv20,tprv35,tprv36,tprv37,tprv38).
compute tprv23 = sum.1(k816,k817).
compute tprv24 = sum.1(k818,k819,k829).
compute tprv25 = sum.1(k828).
compute tprv26 = sum.1(k820,k830).
compute tprv27 = sum.1(k821,k831).
compute tprv28 = sum.1(k822,k832).
compute tprv29 = sum.1(k823,k833).
compute tprv30 = sum.1(k825,k834).
compute tcan = sum.1(tprv23,tprv24,tprv25,tprv26,tprv27,tprv28,tprv29,tprv30,ttiro).
compute totalpar1 = sum.1(tm,tpartom).
compute totalpar2 = sum.1(tm1,tpartoh).

compute tprv31 = sum.1(k707,k708,k716,k717).
compute tpartom  = sum.1(k707,k708).
compute tpartoh  = sum.1(k716,k717).
compute tpc  = sum.1(tn,ta,tad,tm,tm1,tprv31,tedad).
compute tcer = sum.1(k973).
EXECUTE.

VARIABLE LABELS tprv1 'Menores de 1 año'.
VARIABLE LABELS tprv2 '1 - 4 años'.
VARIABLE LABELS tprv3 '5 - 9 años'.
VARIABLE LABELS tn 'Niños'.
VARIABLE LABELS tprv4 '10 - 14 años'.
VARIABLE LABELS tprv5 '15 - 19 años'.
VARIABLE LABELS ta 'Adolescentes'.
VARIABLE LABELS tprv6 '20 - 35 años'.
VARIABLE LABELS tprv7 '36 - 49 años'.
VARIABLE LABELS tprv8 '50 - 64 años'.
VARIABLE LABELS tprv9 '65 años y más'.
VARIABLE LABELS tad 'Adultos'.
VARIABLE LABELS tprv10 'Prenatal 10 - 19 años'.
VARIABLE LABELS tprv11 'Post-parto 10 - 19 años'.
VARIABLE LABELS tm 'Mujeres 10 - 19 años'.
VARIABLE LABELS totalpar1 'Mujeres 10 - 19 años'.
VARIABLE LABELS tprv12 'Prenatal 20 - 49 años'.
VARIABLE LABELS tpartom 'Parto(Atención de partos) 10 - 19 años'.
VARIABLE LABELS tpartoh 'Parto(Atención de partos) 20 - 50 años'.
VARIABLE LABELS tprv13 'Post-parto 20 - 49 años'.
VARIABLE LABELS tm1 'Mujeres 20 - 49 años'.
VARIABLE LABELS totalpar2 'Mujeres 20 - 99 años'.
VARIABLE LABELS tedad 'Edad no especificada'.
VARIABLE LABELS tprv14 'Dispositivo intrauterino diu'.
VARIABLE LABELS tprv32 'Anticonceptivos Orales Combinados'.
VARIABLE LABELS tprv33 'Anticonceptivos Orales sólo progesterona'.
VARIABLE LABELS tprv34 'Anticonceptivo Oral de emergencia'.
VARIABLE LABELS tprv35 'Anillo Vaginal'.
VARIABLE LABELS tprv36 'Parche Trandérmico'.
VARIABLE LABELS tprv37 'Otros'.
VARIABLE LABELS tprv38 'Total sin metodos desglosados'.
VARIABLE LABELS tprv16 'Inyectable'.
VARIABLE LABELS tprv17 'Preservativos'.
VARIABLE LABELS tprv18 'Implantes'.
VARIABLE LABELS tprv19 'Vasectomía'.
VARIABLE LABELS tprv20 'Salpingectomía'.
VARIABLE LABELS tpf 'Planificación familiar'.
VARIABLE LABELS tprv23 'Cérvicouterino'.
VARIABLE LABELS tprv24 'Mamario'.
VARIABLE LABELS tprv25 'Próstata'.
VARIABLE LABELS tprv26 'Pulmonar'.
VARIABLE LABELS tprv27 'Gástrico'.
VARIABLE LABELS tprv28 'Hepático'.
VARIABLE LABELS tprv29 'Colorrectal'.
VARIABLE LABELS tprv30 'Piel'.
VARIABLE LABELS tcan 'Detección oportuna del cáncer'.
VARIABLE LABELS tprv31 'Parto'.
VARIABLE LABELS ttiro 'Tiroide'.
VARIABLE LABELS ttotr 'Otros'.
VARIABLE LABELS tpc 'Total'.
VARIABLE LABELS tcer 'Certificados médicos.'.

VARIABLE LEVEL tprv1 tprv2 tprv3 tn tprv4 tprv5 ta tprv6 tprv7 tprv8 tprv9 tad tprv10 tprv11 tedad ttiro ttotr tm tprv12  tprv13 tm1 tprv14 tprv32 tprv33 tprv34 tprv16 tprv17 tprv18 tprv19 tprv20 
tprv35 tprv36 tprv37 tprv38 tpf tprv23 tprv24 tprv25 tprv26 tprv27 tprv28 tprv29 tprv30 tcan tprv31 tpc tcer totalpar1 totalpar2 tpartom tpartoh(SCALE).

*VARIABLES DE CONSULTAS DE PREVENCION SUBSECUENTE.
numeric tsk1 (F10.0).
numeric tsk2 (F10.0).
numeric tsk3 (F10.0).
numeric tsn (F10.0).
numeric tsk4 (F10.0).
numeric tsk5 (F10.0).
numeric tsad (F10.0).
numeric tsk6 (F10.0).
numeric tsk7 (F10.0).
numeric tsk8 (F10.0).
numeric tsk9 (F10.0).
numeric tsadu (F10.0).
numeric tsk10 (F10.0).
numeric tsk11 (F10.0).
numeric tsmu (F10.0).
numeric tsk12 (F10.0).
numeric tsk13 (F10.0).
numeric tsk19 (F10.0).
numeric tsk20 (F10.0).
numeric tsk14 (F10.0).
numeric tsk15 (F10.0).
numeric tsk16 (F10.0).
numeric tsk17 (F10.0).
numeric tsk18 (F10.0).
numeric tsk22 (F10.0).
numeric tsk23 (F10.0).
numeric tsk24 (F10.0).
numeric tedads(F10.0).



compute tedads = sum.1(k870a,k871a,k872a,k883a,k884a).
compute tsk1 = k836.
compute tsk2 = sum.1(k838,k839).
compute tsk3 = sum.1(k841,k842).
compute tsn = sum.1(tsk1,tsk2,tsk3).
compute tsk4 = sum.1(k844,k845,k846,k852,k853).
compute tsk5 = sum.1(k848,k849,k850,k855,k856).
compute tsad = sum.1(tsk4,tsk5).
compute tsk6 = sum.1(k858,k859,k860,k874,k875).
compute tsk7 = sum.1(k862,k863,k864,k877,k878).
compute tsk8 = sum.1(k866,k867,k868,k880,k881).
compute tsk9 = sum.1(k870,k871,k872,k883,k884).
compute tsadu = sum.1(tsk6,tsk7,tsk8,tsk9).
compute tsk10 = sum.1(k886,k887).
compute tsk11 = sum.1(k888,k889).
compute tsmu = sum.1(tsk10,tsk11).
compute tsk12 = sum.1(k894,k895,k896,k896aa,k930,k931,k932,k932aa).
compute tsk13 = sum.1(k897a,k898a,k899a,k899aa,k900a,k901a,k902a,k902aa,k933a,k934a,k935a,k935aa,k936a,k937a,k938a,k938aa).
compute tsk19 = sum.1(k897b,k898b,k899b,k899bb,k900b,k901b,k902b,k902bb,k933b,k934b,k935b,k935bb,k936b,k937b,k938b,k938bb).
compute tsk20 = sum.1(k897c,k898c,k899c,k899cc,k900c,k901c,k902c,k902cc,k933c,k934c,k935c,k935cc,k936c,k937c,k938c,k938cc).
compute tsk14 = sum.1(k903,k904,k905,k905aa,k906,k907,k908,k908aa,k939,k940,k941,k941aa,k942,k943,k944,k944aa).
compute tsk15 = sum.1(k909,k910,k911,k911aa,k912,k913,k914,k914aa,k945,k946,k947,k947aa,k948,k949,k950,k950aa).
compute tsk16 = sum.1(k915,k916,k917,k917aa,k951,k952,k953,k953aa).
compute tsk17 = sum.1(k913a,k913b,k913c).
compute tsk18 = sum.1(k916a,k917a,k917aaa,k955a,k956a,k956aa).
compute tsk21 = sum.1(k918a,k919a,k920a,k920aa,k954b,k955b,k956b,k956bb).
compute tsk22 = sum.1(k918b,k919b,k920b,k920bb,k954c,k955c,k956c,k956cc).
compute tsk23 = sum.1(k918,k919,k920,k920aaa,k921,k922,k923,k923aa,k954,k955,k956,k956aaa,k957,k958,k959,k959aa).
compute tsk24 = sum.1(k924,k925,k926,k926aa,k927,k928,k929,k929aa,k960,k961,k962,k962aa,k963,k964,k965,k965aa).
EXECUTE.

numeric tspf (F10.0).
numeric tspc (F10.0).
compute tspf = sum.1(tsk12,tsk13,tsk19,tsk20,tsk14,tsk15,tsk16,tsk17,tsk18,tsk21,tsk22,tsk23,tsk24).
compute tspc = sum.1(tsn,tsad,tsadu,tsmu,tedads).
EXECUTE.

VARIABLE LABELS tspc "Total ".
VARIABLE LABELS tsn	"Niños".
VARIABLE LABELS tsk1 "Menores de 1 año".
VARIABLE LABELS tsk2 "1 - 4 años".
VARIABLE LABELS tsk3 "5 - 9 años".
VARIABLE LABELS tsad "Adolescentes".
VARIABLE LABELS tsk4 "10 - 14 años".
VARIABLE LABELS tsk5 "15 - 19 años".
VARIABLE LABELS tsadu "Adultos".
VARIABLE LABELS tsk6 "20 - 35 años".
VARIABLE LABELS tsk7 "36 - 49 años".
VARIABLE LABELS tsk8 "50 - 64 años".
VARIABLE LABELS tsk9 "65 años y más".
VARIABLE LABELS tsmu "Mujeres".
VARIABLE LABELS tsk10 "Prenatal 10 - 19 años".
VARIABLE LABELS tsk11 "Prenatal 20 - 49 años".
VARIABLE LABELS tedads "Edad no especificada".
VARIABLE LABELS tspf "Planificación familiar".
VARIABLE LABELS tsk12 "Dispositivo intrauterino diu".
VARIABLE LABELS tsk13 "Anticonceptivos Orales Combinados".
VARIABLE LABELS tsk19 "Anticonceptivos Orales sólo progesterona".
VARIABLE LABELS tsk20 "Anticonceptivo Oral de emergencia".
VARIABLE LABELS tsk14 "Inyectable".
VARIABLE LABELS tsk15 "Preservativos".
VARIABLE LABELS tsk16 "Implantes".
VARIABLE LABELS tsk17 "Vasectomía".
VARIABLE LABELS tsk18 "Salpingectomía".
VARIABLE LABELS tsk21 "Anillo Vaginal".
VARIABLE LABELS tsk22 "Parche Trandérmico".
VARIABLE LABELS tsk23 "Otros".
VARIABLE LABELS tsk24 "Total sin metodos desglosados".

VARIABLE LEVEL tsk1 tsk2 tsk3 tsn tsk4 tsk5 tsad tsk6 tsk7 tsk8 tsk9 tsadu tsk10 tsk11 tsmu tsk12 tsk13 tsk19 tsk20 tsk14 tsk15 
tsk16 tsk17 tsk18 tsk21 tsk22 tsk23 tsk24 tspf tspc tedads (scale).

*CONSULTAS PRIMARIAS Y SUBSECUENTES DE PREVENCION.
numeric tconpr (F10.0).
compute tconpr=sum.1(tpc,tspc).
VARIABLE LABELS tconpr 'Total Consultas de Prevención'.
EXECUTE.
VARIABLE LABELS tpc 'Consultas Primarias'.
VARIABLE LABELS tspc 'Consultas Subsecuentes'.

*CONSULTAS DE MORBILIDAD ESTOMATOLOGÍA.
numeric tnin (F10.0).
numeric tadole (F10.0).
numeric tadult (F10.0).
numeric totalm (F10.0).
compute tnin = sum.1(k1069,k1072,k1075).
compute tadole = sum.1(k1078,k1084).
compute tadult = sum.1(k1087,k1090,k1093,k1096).
VARIABLE LABELS tnin 'Total niños' /tadole 'Total adolescentes' /tadult 'Total adultos'.
compute totalm=sum.1(tnin,tadole,tadult,k1081,k1099,k1102a,1102).
VARIABLE LABELS totalm 'Total Consultas Estomatología Morbilidad'.
EXECUTE.

numeric niños (F1.0).
numeric adolsc (F1.0).
numeric adulto (F1.0).
if tnin>0 niños=1.
if tadole>0 adolsc=1.
if tadult>0 adulto=1.
VARIABLE LABELS niños 'Niños' /adolsc 'Adolescentes' /adulto 'Adultos'.
VALUE LABELS niños 1'Niños' /adolsc 1'Adolescentes' /adulto 1'Adultos'.

VARIABLE LEVEL tconpr tconpr tnin tadole tadult totalm(scale).
EXECUTE.

VARIABLE LEVEL k1069  k1070 k1071 k1073 k1072  k1074 k1075 k1076 k1077 k1078 k1079 k1080 k1081 k1082 k1083 k1084 k1085 k1086 k1087 k1088 k1089 k1090 k1091 k1092 k1093 k1094 k1095 k1096 k1097 k1098 k1099 k1100 k1101 k1102 k1103 k1104 
k1105 niños adolsc adulto(SCALE).
VARIABLE LABELS k1069 ' Menores de 1 año' .
VARIABLE LABELS k1072 ' 1 - 4 años' .
VARIABLE LABELS k1075 ' 5 - 9 años programados' .
VARIABLE LABELS k1078 ' 10 - 14 años programados' .
VARIABLE LABELS k1081 ' 5 - 14 años no programados' .
VARIABLE LABELS k1084 ' 15 - 19 años' .
VARIABLE LABELS k1087 ' 20 -35 años' .
VARIABLE LABELS k1090 ' 36 - 49 años' .
VARIABLE LABELS k1093 ' 50 - 64 años' .
VARIABLE LABELS k1096 ' 65 y más años' .
VARIABLE LABELS k1099 ' Embarazadas' .
VARIABLE LABELS k1102a ' No especificada' .
VARIABLE LABELS k1102 ' Total 2 sin grupos de edad/' .
VARIABLE LABELS k1105 'Consultas Estomatología Morbilidad' .
VARIABLE LEVEL k1106 k1107 k1108 k1109(SCALE).
*PRIMERAS CONSULTAS DE PREVENCION ESTOMATOLOGÍA.
numeric tpnin (F10.0).
numeric tpadole (F10.0).
numeric tpadult (F10.0).
numeric totaln (F10.0).
compute tpnin = sum.1(k1070,k1073,k1076).
compute tpadole = sum.1(k1079,k1085).
compute tpadult = sum.1(k1088,k1091,k1094,k1097).
VARIABLE LABELS tpnin 'Total prev. prim. niños' /tpadole 'Total prev. prim. adolescentes' /tpadult 'Total prev. prim. adultos'.
compute totaln=sum.1(tpnin,tpadole,tpadult,k1082,k1100,k1103,k1103a).
VARIABLE LABELS totaln 'Total Primarias'.
VARIABLE LEVEL tpnin tpadole tpadult totaln(scale).
EXECUTE.

numeric pniños (F1.0).
numeric padolsc (F1.0).
numeric padulto (F1.0).
if tpnin>0 pniños=1.
if tpadole>0 padolsc=1.
if tpadult>0 padulto=1.
VARIABLE LABELS pniños 'Niños' /padolsc 'Adolescentes' /padulto 'Adultos'.
VALUE LABELS pniños 1'Niños' /padolsc 1'Adolescentes' /padulto 1'Adultos'.
EXECUTE.

VARIABLE LABELS k1070 ' Menores de 1 año' .
VARIABLE LABELS k1073 ' 1 - 4 años' .
VARIABLE LABELS k1076 ' 5 - 9 años programados' .
VARIABLE LABELS k1079 ' 10 - 14 años programados' .
VARIABLE LABELS k1082 ' 5 - 14 años no programados' .
VARIABLE LABELS k1085 ' 15 - 19 años' .
VARIABLE LABELS k1088 ' 20 -35 años' .
VARIABLE LABELS k1091 ' 36 - 49 años' .
VARIABLE LABELS k1094 ' 50 - 64 años' .
VARIABLE LABELS k1097 ' 65 y más años' .
VARIABLE LABELS k1100 ' Embarazadas' .
VARIABLE LABELS k1103a ' No Especificada' .
VARIABLE LABELS k1103 ' Total*sin grupos de edad' .
VARIABLE LABELS k1106 'Primeras' .

*CONSULTAS SUBSECUENTES DE PREVENCION ESTOMATOLOGÍA.
numeric tsnin (F10.0).
numeric tsadole (F10.0).
numeric tsadult (F10.0).
numeric totalsubp (F10.0).
compute tsnin = sum.1(k1071,k1074,k1077).
compute tsadole = sum.1(k1080,k1086).
compute tsadult = sum.1(k1089,k1092,k1095,k1098).
compute totalsubp = sum.1(tsnin,tsadole,tsadult,k1083,k1101,k1104,k1104a).
VARIABLE LABELS tsnin 'Total sub. prim. niños' /tsadole 'Total sub. prim. adolesc.' /tsadult 'Total sub. prim. adult.' /totalsubp 'Total Subsecuentes'.
VARIABLE LEVEL tsnin tsadole tsadult totalsubp(scale).
EXECUTE.

numeric sniños (F1.0).
numeric sadolsc (F1.0).
numeric sadulto (F1.0).
if tsnin>0 sniños=1.
if tsadole>0 sadolsc=1.
if tsadult>0 sadulto=1.
VARIABLE LABELS sniños 'Niños' /sadolsc 'Adolescentes' /sadulto 'Adultos'.
VALUE LABELS sniños 1'Niños' /sadolsc 1'Adolescentes' /sadulto 1'Adultos'.
EXECUTE.

VARIABLE LABELS k1071 ' Menores de 1 año' .
VARIABLE LABELS k1074 ' 1 - 4 años' .
VARIABLE LABELS k1077 ' 5 - 9 años programados' .
VARIABLE LABELS k1080 ' 10 - 14 años programados' .
VARIABLE LABELS k1083 ' 5 - 14 años no programados' .
VARIABLE LABELS k1086 ' 15 - 19 años' .
VARIABLE LABELS k1089 ' 20 -35 años' .
VARIABLE LABELS k1092 ' 36 - 49 años' .
VARIABLE LABELS k1095 ' 50 - 64 años' .
VARIABLE LABELS k1098 ' 65 y más años' .
VARIABLE LABELS k1101 ' Embarazadas' .
VARIABLE LABELS k1104a ' No Especificada' .
VARIABLE LABELS k1104 ' Total*sin grupos de edad' .
VARIABLE LABELS k1107 'Subsecuentes' .

*TOTAL DE CONSULTAS DE PREVENCION ESTOMATOLOGÍA.

numeric totalcest (F10.0).
numeric totalpsub (F10.0).
numeric tconpsp (F1.0).
numeric tconmorb (F1.0).
compute totalcest = sum.1(k1105,totaln,totalsubp).
compute totalpsub = sum.1(totaln,totalsubp).
if (totalpsub>0) tconpsp=1.
if (k1105>0) tconmorb=1.
VARIABLE LABELS tconmorb 'Morbilidad'.
VARIABLE LABELS tconpsp 'Prevención'.
VALUE LABELS tconmorb 1'Morbilidad'.
VALUE LABELS tconpsp 1'Prevención'.
VARIABLE LABELS totalcest 'Total de consultas estomatologia'.
VARIABLE LABELS totalpsub 'Total consultas prevención'.
VARIABLE LEVEL totalcest totalpsub tconpsp tconmorb k1112 k1113 k1114 k1114a k1115 k1116 k1117 k1118 k1118a k1119 k1120 k1121 k1121a(SCALE).
EXECUTE.

*VARIABLES PARA ACTIVIDADES DE MORBILIDAD Y PREVENCION - ESTOMATOLOGIA.

VARIABLE LEVEL k1108 k1109 k1110 k1111 k1112 k1113 k1114 k1114a k1115 k1116 k1117 k1118 k1118a k1119 k1120 k1121 k1121a(SCALE).
VARIABLE LABELS k1108 'Obturación'.
VARIABLE LABELS k1109 'Restauración'.
VARIABLE LABELS k1110 'Endodoncias'.
VARIABLE LABELS k1111 'Exodoncias'.
VARIABLE LABELS k1112 'Periodoncias'.
VARIABLE LABELS k1113 'Cirugía Menor'.
VARIABLE LABELS k1114 'Ortodoncia / Ortopedia'.
VARIABLE LABELS k1114a 'Total: Si no dispone de las actividades desagregadas'.
VARIABLE LABELS k1115 'Total Consultas morbilidad'.
VARIABLE LABELS k1116 'Profilaxis'.
VARIABLE LABELS k1117 'Aplicación de Fluor'.
VARIABLE LABELS k1118 'Sellantes'.
VARIABLE LABELS k1118a 'Total: Si no dispone de las actividades desagregadas'.
VARIABLE LABELS k1120 'Número de Radiografías Dentales'.
VARIABLE LABELS k1121 'Número de Certificados Odontológicos'.
VARIABLE LABELS k1119 'Total Consultas act. prevención'.
VARIABLE LABELS k1121a 'Total Radiografías y certificados'.
EXECUTE.

numeric tactm (F1.0).
numeric tactp (F1.0).
if k1115>0 tactm=1.
if k1119>0 tactp=1.
VALUE LABELS tactm 1'Actividades de morbilidad ' /tactp 1'Actividades de prevención '.
EXECUTE.


*VARIABLES DE EXAMENES DE LABORATORIO Y ANATOMIA PATOLOGIA.

*LABORATORIO.
numeric texalb (F1.0).
if(k1178>0) texalb = 1.
VARIABLE LABELS texalb "Exámenes de Laboratorio".
VALUE LABELS texalb	1"Exámenes de Laboratorio".
EXECUTE.

*ANATOMIA PATOLOGICA.
numeric anatp (F1.0).
if(k1193>0) anatp = 1.
VARIABLE LABELS anatp "Anatomía patológica".
VALUE LABELS anatp 1"Anatomía patológica".
EXECUTE.

VARIABLE LABELS k1122 "Flebotomía".
VARIABLE LABELS k1126 "Hematologia".
VARIABLE LABELS k1130 "Quimica Sanguinea".
VARIABLE LABELS k1134 "Inmunología".
VARIABLE LABELS k1138 "Uroanálisis".
VARIABLE LABELS k1142 "Coproanálisis".
VARIABLE LABELS k1146 "Microbiología ".
VARIABLE LABELS k1150 "Serologia".
VARIABLE LABELS k1154 "Hormonas".
VARIABLE LABELS k1158 "Tuberculosis".
VARIABLE LABELS k1162 "Biología Molecular (opcional)".
VARIABLE LABELS k1166 "Toxicología (opcional)".
VARIABLE LABELS k1170 "Genética (opcional)".
VARIABLE LABELS k1174 "Otros".
VARIABLE LABELS k1174a "Pruebas de VIH (Positivas)".
VARIABLE LABELS k1174b "Pruebas de VIH (Negativas)".
VARIABLE LABELS k1174d "Pruebas de COVID (Positivas)".
VARIABLE LABELS k1174c "Pruebas de COVID (Negativas)".

VARIABLE LABELS k1182 "Exámenes Histopatológicos".
VARIABLE LABELS k1185 "Citológicos".
VARIABLE LABELS k1188 "Autopsias".
VARIABLE LABELS k1190 "Otros".
VARIABLE LABELS k1199 "Recetas despachadas en farmacia".

VARIABLE LEVEL k1122 k1126 k1130 k1134 k1138 k1142 k1146 k1150 k1154 k1158 k1162 k1166 k1170 k1174 k1182 k1185 k1188 k1190 k1174d k1174c(SCALE).
VARIABLE LEVEL k1122 k1126 k1130 k1134 k1138 k1142 k1146 k1150 k1154 k1158 k1162 k1166 k1170 k1174 k1174a k1174b k1182 
k1183 k1185 k1188 k1190 k1199 (scale).

*VARIABLES DE EXAMENES DE DESINNOLOGIA.
numeric tklg1 (F10.0).
numeric tklg2 (F10.0).
numeric tklg3 (F10.0).
numeric tklg4 (F10.0).
numeric tklg5 (F10.0).
numeric tklg6 (F10.0).
numeric tklg7 (F10.0).
numeric texai (F10.0).

compute tklg1 = sum.1(k1210,k1211,k1212,k1218,k1219,k1220,k1230,k1231,k1232,k1242,k1243,k1244).
compute tklg2 = sum.1(k1214,k1215,k1216,k1254,k1255,k1256).
compute tklg3 = sum.1(k1222,k1223,k1224,k1246,k1247,k1248).
compute tklg4 = sum.1(k1226,k1227,k1228,k1250,k1251,k1252).
compute tklg5 = sum.1(k1234,k1235,k1236).
compute tklg6 = sum.1(k1238,k1239,k1240).
compute tklg7 = sum.1(k1258,k1259,k1260).
compute texai = sum.1(tklg1,tklg2,tklg3,tklg4,tklg5,tklg6,tklg7).
numeric exai (F1.0).
if texai>0 exai = 1.
VALUE LABELS exai 1"Exámenes de Imagenología".
EXECUTE.

* Etiquetar variables.
VARIABLE LABELS texai "Total Exámenes de Imagenología"
/tklg1	"Radiografías"
/tklg2	"Ecografías"
/tklg3	"Tomografías"
/tklg4	"Mamografías"
/tklg5	"Dosimetría ósea"
/tklg6	"Resonancia magnética nuclear intervencionista "
/tklg7	"Otros"
/exai	"Exámenes de imagenología"
/t	"Total".
VARIABLE LEVEL tklg1 tklg2 tklg3 tklg4 tklg5 tklg6 tklg7 texai(SCALE).
*VARIALBES DE PRUEBAS DE DIAGNOSTICO.
numeric tprubd (F10.0).
compute tprubd = sum.1(k1279,k1283,k1287,k1291,1295,k1299,k1303,k1307,k1315,k1319,k1335).
numeric prubd (F1.0).
if(tprubd>0) prubd=1.
VARIABLE LABELS prubd "Pruebas de Diagnóstico".
VALUE LABELS prubd 1"Pruebas de Diagnóstico".
EXECUTE.

VARIABLE LABELS k1279 "Electroencefalogramas".
VARIABLE LABELS k1283 "Electrocardiogramas".
VARIABLE LABELS k1287 "Ecocardiogramas".
VARIABLE LABELS k1291 "Angiografías".
VARIABLE LABELS k1295 "Espirometrías".
VARIABLE LABELS k1299 "Ergonometrías".
VARIABLE LABELS k1303 "Endoscopías".
VARIABLE LABELS k1307 "Colonoscopías".
VARIABLE LABELS k1315 "Audiometrías".
VARIABLE LABELS k1319 "Electromiogramas".
VARIABLE LABELS k1335 "Otros".

VARIABLE LEVEL k1279 k1283 k1287 k1291 k1295 k1299 k1303 k1307 k1315 k1319 k1335(SCALE).

*TRATAMIENTOS DE FISOTERAPIA.

numeric ttrafis (F10.0).
compute ttrafis = sum.1(k1348,k1351,k1354,k1357,k1360,k1363,k1363a,k1366).
numeric tfisiot (F1.0).
if(ttrafis>0) tfisiot = 1.
VALUE LABELS tfisiot 1"Tratamiento de Fisioterapia".
EXECUTE.
numeric tgama (F10.0).
compute tgama = sum.1(k1323,k1326,k1329,k1332).
numeric gamas (F1.0).
if(tgama>0) gamas = 1.
VALUE LABELS gamas 1"Pruebas de diagnostico con radioisótopos".
EXECUTE.
numeric ttram (F10.0).
compute ttram = sum.1(k1372,k1373,k1374).
numeric totramt (F1.0).
if(ttram>0) totramt = 1.
VALUE LABELS totramt 1"Otros Tratamientos".
EXECUTE.

VARIABLE LABELS k1348 "Electroterapia".
VARIABLE LABELS k1351 "Hidroterapia".
VARIABLE LABELS k1354 "Ejercicios Terapeúticos".
VARIABLE LABELS k1357 "Parafina".
VARIABLE LABELS k1360 "Compresas químicas ".
VARIABLE LABELS k1363 "Termoterapia".
VARIABLE LABELS k1363a "Litotricia".
VARIABLE LABELS k1366 "Otros".
VARIABLE LABELS k1323 "Gammagrafía Tiroidea".
VARIABLE LABELS k1326 "Gammagrafía Ósea".
VARIABLE LABELS k1329 "Gammagrafía Renal".
VARIABLE LABELS k1332 "Gammagrafía de Otros Órganos".
VARIABLE LABELS k1372 "Terapia de lenguaje".
VARIABLE LABELS k1373 "Terapia respiratoria".
VARIABLE LABELS k1374 "Terapia ocupacional".
VARIABLE LABELS k1376a "Tratamientos de diálisis y hemodiálisis".
VARIABLE LABELS k1376b "Tratamientos de quimioterapias".
VARIABLE LABELS k1376c "Tratamientos de radioterapia".
VARIABLE LABELS k1376bb "Tratamientos de quimioterapias tópicos".
VARIABLE LABELS k1376d "Tratamientos de hemodiálisis".
VARIABLE LABELS k1376e "Otros".

VARIABLE LEVEL k1348 k1351 k1354 k1357 k1360 k1363 k1366  k1323 k1326 k1329 k1332  k1372 k1373 k1374 k1376a k1376b k1376c k1376d k1363a k1376e(SCALE).
VARIABLE LEVEL k1348 k1351 k1354 k1357 k1360 k1363 k1366  k1323 k1326 k1329 k1332  k1372 k1373 k1374 k1376a k1376b k1376c k1376d k1376bb(SCALE).

*VARIABLES DE TRABAJO SOCIAL.

numeric totvisi (F10.0).
compute totvisi = sum.1(k1419,k1420).
numeric visita (F1.0).
if(totvisi>0) visita = 1.
VALUE LABELS visita 1 "Visitas Domiciliarias".
EXECUTE.

VARIABLE LABELS k1418 "Entrevistas".
VARIABLE LABELS k1419 "Visitas domiciliarias efectivas".
VARIABLE LABELS k1420 "Visitas domiciliarias inefectivas".
VARIABLE LABELS k1421 "Gestiones Intra institucionales".
VARIABLE LABELS k1422 "Gestiones Extra institucionales".
VARIABLE LABELS k1423 "Servicio Social a la comunidad".
VARIABLE LABELS k972 "Total visitas domiciliadas Consultas ".
VARIABLE LEVEL k1418 k1419 k1420 k1421 k1422 k1423 k972(SCALE).

*ACTIVIDADES DE VIGILANCIA SANITARIA.

VARIABLE LABELS k1412 "  Viviendas".
VARIABLE LABELS k1413 "  Establecimientos educacionales".
VARIABLE LABELS k1414 "  Establecimientos públicos en general".
VARIABLE LABELS k1415 "  Establecimientos de expendio de alimentos".
VARIABLE LABELS k1416 "  Otras".

VARIABLE LEVEL k1412 k1413 k1414 k1415 k1416(SCALE).
VARIABLE LEVEL k1412 k1413 k1414 k1415 k1416(SCALE).
EXECUTE.











